include(__link__.m4)

#ifndef __ZXN_COLOR_H__
#define __ZXN_COLOR_H__

#include <arch.h>

/*
   Some good sources of palettes:

     https://lospec.com/palette-list
     http://www.color-hex.com/color-palettes/
     http://www.color-hex.com/color-palettes/popular.php

   Associate a name with a colour:
  
     http://www.color-blindness.com/color-name-hue/

   Some colours here may need manual tweaking

   Use the m4 colour macros in macro/zxn-color.m4 to convert
   from various RGB spaces to the Next's RGB332 and RGB333 formats.

   https://github.com/z88dk/z88dk/blob/master/libsrc/_DEVELOPMENT/target/zxn/macro/zxn-color.m4
*/

// NEXTOS INITIAL COLOURS

#define ZXN_RGB332_NEXTOS_BLACK  __ZXN_RGB332_NEXTOS_BLACK
#define ZXN_RGB332_NEXTOS_BLUE  __ZXN_RGB332_NEXTOS_BLUE
#define ZXN_RGB332_NEXTOS_RED  __ZXN_RGB332_NEXTOS_RED
#define ZXN_RGB332_NEXTOS_MAGENTA  __ZXN_RGB332_NEXTOS_MAGENTA
#define ZXN_RGB332_NEXTOS_GREEN  __ZXN_RGB332_NEXTOS_GREEN
#define ZXN_RGB332_NEXTOS_CYAN  __ZXN_RGB332_NEXTOS_CYAN
#define ZXN_RGB332_NEXTOS_YELLOW  __ZXN_RGB332_NEXTOS_YELLOW
#define ZXN_RGB332_NEXTOS_WHITE  __ZXN_RGB332_NEXTOS_WHITE

#define ZXN_RGB332_NEXTOS_BRIGHT_BLACK  __ZXN_RGB332_NEXTOS_BRIGHT_BLACK
#define ZXN_RGB332_NEXTOS_BRIGHT_BLUE  __ZXN_RGB332_NEXTOS_BRIGHT_BLUE
#define ZXN_RGB332_NEXTOS_BRIGHT_RED  __ZXN_RGB332_NEXTOS_BRIGHT_RED
#define ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA  __ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA
#define ZXN_RGB332_NEXTOS_BRIGHT_GREEN  __ZXN_RGB332_NEXTOS_BRIGHT_GREEN
#define ZXN_RGB332_NEXTOS_BRIGHT_CYAN  __ZXN_RGB332_NEXTOS_BRIGHT_CYAN
#define ZXN_RGB332_NEXTOS_BRIGHT_YELLOW  __ZXN_RGB332_NEXTOS_BRIGHT_YELLOW
#define ZXN_RGB332_NEXTOS_BRIGHT_WHITE  __ZXN_RGB332_NEXTOS_BRIGHT_WHITE

// PRIMARY AND SECONDARY COLOURS

// Red

#define ZXN_RGB332_RED_0  __ZXN_RGB332_RED_0
#define ZXN_RGB332_RED_1  __ZXN_RGB332_RED_1
#define ZXN_RGB332_RED_2  __ZXN_RGB332_RED_2
#define ZXN_RGB332_RED_3  __ZXN_RGB332_RED_3
#define ZXN_RGB332_RED_4  __ZXN_RGB332_RED_4
#define ZXN_RGB332_RED_5  __ZXN_RGB332_RED_5
#define ZXN_RGB332_RED_6  __ZXN_RGB332_RED_6

#define ZXN_RGB333_RED_0  __ZXN_RGB333_RED_0
#define ZXN_RGB333_RED_1  __ZXN_RGB333_RED_1
#define ZXN_RGB333_RED_2  __ZXN_RGB333_RED_2
#define ZXN_RGB333_RED_3  __ZXN_RGB333_RED_3
#define ZXN_RGB333_RED_4  __ZXN_RGB333_RED_4
#define ZXN_RGB333_RED_5  __ZXN_RGB333_RED_5
#define ZXN_RGB333_RED_6  __ZXN_RGB333_RED_6

// Green

#define ZXN_RGB332_GREEN_0  __ZXN_RGB332_GREEN_0
#define ZXN_RGB332_GREEN_1  __ZXN_RGB332_GREEN_1
#define ZXN_RGB332_GREEN_2  __ZXN_RGB332_GREEN_2
#define ZXN_RGB332_GREEN_3  __ZXN_RGB332_GREEN_3
#define ZXN_RGB332_GREEN_4  __ZXN_RGB332_GREEN_4
#define ZXN_RGB332_GREEN_5  __ZXN_RGB332_GREEN_5
#define ZXN_RGB332_GREEN_6  __ZXN_RGB332_GREEN_6

#define ZXN_RGB333_GREEN_0  __ZXN_RGB333_GREEN_0
#define ZXN_RGB333_GREEN_1  __ZXN_RGB333_GREEN_1
#define ZXN_RGB333_GREEN_2  __ZXN_RGB333_GREEN_2
#define ZXN_RGB333_GREEN_3  __ZXN_RGB333_GREEN_3
#define ZXN_RGB333_GREEN_4  __ZXN_RGB333_GREEN_4
#define ZXN_RGB333_GREEN_5  __ZXN_RGB333_GREEN_5
#define ZXN_RGB333_GREEN_6  __ZXN_RGB333_GREEN_6

// Blue

#define ZXN_RGB332_BLUE_0  __ZXN_RGB332_BLUE_0
#define ZXN_RGB332_BLUE_1  __ZXN_RGB332_BLUE_1
#define ZXN_RGB332_BLUE_2  __ZXN_RGB332_BLUE_2

#define ZXN_RGB333_BLUE_0  __ZXN_RGB333_BLUE_0
#define ZXN_RGB333_BLUE_1  __ZXN_RGB333_BLUE_1
#define ZXN_RGB333_BLUE_2  __ZXN_RGB333_BLUE_2
#define ZXN_RGB333_BLUE_3  __ZXN_RGB333_BLUE_3
#define ZXN_RGB333_BLUE_4  __ZXN_RGB333_BLUE_4
#define ZXN_RGB333_BLUE_5  __ZXN_RGB333_BLUE_5
#define ZXN_RGB333_BLUE_6  __ZXN_RGB333_BLUE_6

// Yellow

#define ZXN_RGB332_YELLOW_0  __ZXN_RGB332_YELLOW_0
#define ZXN_RGB332_YELLOW_1  __ZXN_RGB332_YELLOW_1
#define ZXN_RGB332_YELLOW_2  __ZXN_RGB332_YELLOW_2
#define ZXN_RGB332_YELLOW_3  __ZXN_RGB332_YELLOW_3
#define ZXN_RGB332_YELLOW_4  __ZXN_RGB332_YELLOW_4
#define ZXN_RGB332_YELLOW_5  __ZXN_RGB332_YELLOW_5
#define ZXN_RGB332_YELLOW_6  __ZXN_RGB332_YELLOW_6

#define ZXN_RGB333_YELLOW_0  __ZXN_RGB333_YELLOW_0
#define ZXN_RGB333_YELLOW_1  __ZXN_RGB333_YELLOW_1
#define ZXN_RGB333_YELLOW_2  __ZXN_RGB333_YELLOW_2
#define ZXN_RGB333_YELLOW_3  __ZXN_RGB333_YELLOW_3
#define ZXN_RGB333_YELLOW_4  __ZXN_RGB333_YELLOW_4
#define ZXN_RGB333_YELLOW_5  __ZXN_RGB333_YELLOW_5
#define ZXN_RGB333_YELLOW_6  __ZXN_RGB333_YELLOW_6

// Magenta

#define ZXN_RGB332_MAGENTA_0  __ZXN_RGB332_MAGENTA_0
#define ZXN_RGB332_MAGENTA_1  __ZXN_RGB332_MAGENTA_1
#define ZXN_RGB332_MAGENTA_2  __ZXN_RGB332_MAGENTA_2

#define ZXN_RGB333_MAGENTA_0  __ZXN_RGB333_MAGENTA_0
#define ZXN_RGB333_MAGENTA_1  __ZXN_RGB333_MAGENTA_1
#define ZXN_RGB333_MAGENTA_2  __ZXN_RGB333_MAGENTA_2
#define ZXN_RGB333_MAGENTA_3  __ZXN_RGB333_MAGENTA_3
#define ZXN_RGB333_MAGENTA_4  __ZXN_RGB333_MAGENTA_4
#define ZXN_RGB333_MAGENTA_5  __ZXN_RGB333_MAGENTA_5
#define ZXN_RGB333_MAGENTA_6  __ZXN_RGB333_MAGENTA_6

// Cyan

#define ZXN_RGB332_CYAN_0  __ZXN_RGB332_CYAN_0
#define ZXN_RGB332_CYAN_1  __ZXN_RGB332_CYAN_1
#define ZXN_RGB332_CYAN_2  __ZXN_RGB332_CYAN_2

#define ZXN_RGB333_CYAN_0  __ZXN_RGB333_CYAN_0
#define ZXN_RGB333_CYAN_1  __ZXN_RGB333_CYAN_1
#define ZXN_RGB333_CYAN_2  __ZXN_RGB333_CYAN_2
#define ZXN_RGB333_CYAN_3  __ZXN_RGB333_CYAN_3
#define ZXN_RGB333_CYAN_4  __ZXN_RGB333_CYAN_4
#define ZXN_RGB333_CYAN_5  __ZXN_RGB333_CYAN_5
#define ZXN_RGB333_CYAN_6  __ZXN_RGB333_CYAN_6

// SHADES

// Monochrome
// http://unwind.se/bgr233/

#define ZXN_RGB332_MONO_GRAY_0  __ZXN_RGB332_MONO_GRAY_0
#define ZXN_RGB332_MONO_GRAY_1  __ZXN_RGB332_MONO_GRAY_1
#define ZXN_RGB332_MONO_GRAY_2  __ZXN_RGB332_MONO_GRAY_2
#define ZXN_RGB332_MONO_GRAY_3  __ZXN_RGB332_MONO_GRAY_3

#define ZXN_RGB333_MONO_GRAY_0  __ZXN_RGB333_MONO_GRAY_0
#define ZXN_RGB333_MONO_GRAY_1  __ZXN_RGB333_MONO_GRAY_1
#define ZXN_RGB333_MONO_GRAY_2  __ZXN_RGB333_MONO_GRAY_2
#define ZXN_RGB333_MONO_GRAY_3  __ZXN_RGB333_MONO_GRAY_3
#define ZXN_RGB333_MONO_GRAY_4  __ZXN_RGB333_MONO_GRAY_4
#define ZXN_RGB333_MONO_GRAY_5  __ZXN_RGB333_MONO_GRAY_5
#define ZXN_RGB333_MONO_GRAY_6  __ZXN_RGB333_MONO_GRAY_6
#define ZXN_RGB333_MONO_GRAY_7  __ZXN_RGB333_MONO_GRAY_7

// Amber
// https://sites.google.com/site/ulaplus/

#define ZXN_RGB332_AMBER_0  __ZXN_RGB332_AMBER_0
#define ZXN_RGB332_AMBER_1  __ZXN_RGB332_AMBER_1
#define ZXN_RGB332_AMBER_2  __ZXN_RGB332_AMBER_2
#define ZXN_RGB332_AMBER_3  __ZXN_RGB332_AMBER_3
#define ZXN_RGB332_AMBER_4  __ZXN_RGB332_AMBER_4
#define ZXN_RGB332_AMBER_5  __ZXN_RGB332_AMBER_5
#define ZXN_RGB332_AMBER_6  __ZXN_RGB332_AMBER_6

// http://www.htmlcsscolor.com/hex/FFBF00

#define ZXN_RGB333_AMBER_0  __ZXN_RGB333_AMBER_0
#define ZXN_RGB333_AMBER_1  __ZXN_RGB333_AMBER_1
#define ZXN_RGB333_AMBER_2  __ZXN_RGB333_AMBER_2
#define ZXN_RGB333_AMBER_3  __ZXN_RGB333_AMBER_3
#define ZXN_RGB333_AMBER_4  __ZXN_RGB333_AMBER_4
#define ZXN_RGB333_AMBER_5  __ZXN_RGB333_AMBER_5

// SKIN TONE

// Caucasian Skin Tone
// http://www.color-hex.com/color-palette/737

#define ZXN_RGB332_SKINC_0  __ZXN_RGB332_SKINC_0
#define ZXN_RGB332_SKINC_1  __ZXN_RGB332_SKINC_1
#define ZXN_RGB332_SKINC_2  __ZXN_RGB332_SKINC_2
#define ZXN_RGB332_SKINC_3  __ZXN_RGB332_SKINC_3
#define ZXN_RGB332_SKINC_4  __ZXN_RGB332_SKINC_4

#define ZXN_RGB333_SKINC_0  __ZXN_RGB333_SKINC_0
#define ZXN_RGB333_SKINC_1  __ZXN_RGB333_SKINC_1
#define ZXN_RGB333_SKINC_2  __ZXN_RGB333_SKINC_2
#define ZXN_RGB333_SKINC_3  __ZXN_RGB333_SKINC_3
#define ZXN_RGB333_SKINC_4  __ZXN_RGB333_SKINC_4

// Skin Tones
// http://www.color-hex.com/color-palette/547

#define ZXN_RGB332_SKINT_0  __ZXN_RGB332_SKINT_0
#define ZXN_RGB332_SKINT_1  __ZXN_RGB332_SKINT_1
#define ZXN_RGB332_SKINT_2  __ZXN_RGB332_SKINT_2
#define ZXN_RGB332_SKINT_3  __ZXN_RGB332_SKINT_3
#define ZXN_RGB332_SKINT_4  __ZXN_RGB332_SKINT_4

#define ZXN_RGB333_SKINT_0  __ZXN_RGB333_SKINT_0
#define ZXN_RGB333_SKINT_1  __ZXN_RGB333_SKINT_1
#define ZXN_RGB333_SKINT_2  __ZXN_RGB333_SKINT_2
#define ZXN_RGB333_SKINT_3  __ZXN_RGB333_SKINT_3
#define ZXN_RGB333_SKINT_4  __ZXN_RGB333_SKINT_4

// Skin and Lips
// http://www.color-hex.com/color-palette/6203

#define ZXN_RGB332_SKINL_0  __ZXN_RGB332_SKINL_0
#define ZXN_RGB332_SKINL_1  __ZXN_RGB332_SKINL_1
#define ZXN_RGB332_SKINL_2  __ZXN_RGB332_SKINL_2
#define ZXN_RGB332_SKINL_3  __ZXN_RGB332_SKINL_3
#define ZXN_RGB332_SKINL_4  __ZXN_RGB332_SKINL_4

#define ZXN_RGB333_SKINL_0  __ZXN_RGB333_SKINL_0
#define ZXN_RGB333_SKINL_1  __ZXN_RGB333_SKINL_1
#define ZXN_RGB333_SKINL_2  __ZXN_RGB333_SKINL_2
#define ZXN_RGB333_SKINL_3  __ZXN_RGB333_SKINL_3
#define ZXN_RGB333_SKINL_4  __ZXN_RGB333_SKINL_4

// Dark Skin Tones
// http://www.color-hex.com/color-palette/4613

#define ZXN_RGB332_SKIND_0  __ZXN_RGB332_SKIND_0
#define ZXN_RGB332_SKIND_1  __ZXN_RGB332_SKIND_1
#define ZXN_RGB332_SKIND_2  __ZXN_RGB332_SKIND_2
#define ZXN_RGB332_SKIND_3  __ZXN_RGB332_SKIND_3
#define ZXN_RGB332_SKIND_4  __ZXN_RGB332_SKIND_4

#define ZXN_RGB333_SKIND_0  __ZXN_RGB333_SKIND_0
#define ZXN_RGB333_SKIND_1  __ZXN_RGB333_SKIND_1
#define ZXN_RGB333_SKIND_2  __ZXN_RGB333_SKIND_2
#define ZXN_RGB333_SKIND_3  __ZXN_RGB333_SKIND_3
#define ZXN_RGB333_SKIND_4  __ZXN_RGB333_SKIND_4

// CORPORATE

// Facebook
// http://www.color-hex.com/color-palette/185

#define ZXN_RGB332_FACEBOOK_0  __ZXN_RGB332_FACEBOOK_0
#define ZXN_RGB332_FACEBOOK_1  __ZXN_RGB332_FACEBOOK_1
#define ZXN_RGB332_FACEBOOK_2  __ZXN_RGB332_FACEBOOK_2
#define ZXN_RGB332_FACEBOOK_3  __ZXN_RGB332_FACEBOOK_3
#define ZXN_RGB332_FACEBOOK_4  __ZXN_RGB332_FACEBOOK_4
#define ZXN_RGB332_FACEBOOK_5  __ZXN_RGB332_FACEBOOK_5

#define ZXN_RGB333_FACEBOOK_0  __ZXN_RGB333_FACEBOOK_0
#define ZXN_RGB333_FACEBOOK_1  __ZXN_RGB333_FACEBOOK_1
#define ZXN_RGB333_FACEBOOK_2  __ZXN_RGB333_FACEBOOK_2
#define ZXN_RGB333_FACEBOOK_3  __ZXN_RGB333_FACEBOOK_3
#define ZXN_RGB333_FACEBOOK_4  __ZXN_RGB333_FACEBOOK_4
#define ZXN_RGB333_FACEBOOK_5  __ZXN_RGB333_FACEBOOK_5

// Facebook Messenger
// http://www.color-hex.com/color-palette/15945

#define ZXN_RGB332_FBM_BLUE  __ZXN_RGB332_FBM_BLUE
#define ZXN_RGB332_FBM_CYAN  __ZXN_RGB332_FBM_CYAN
#define ZXN_RGB332_FBM_YELLOW  __ZXN_RGB332_FBM_YELLOW
#define ZXN_RGB332_FBM_RED  __ZXN_RGB332_FBM_RED
#define ZXN_RGB332_FBM_PURPLE  __ZXN_RGB332_FBM_PURPLE

#define ZXN_RGB333_FBM_BLUE  __ZXN_RGB333_FBM_BLUE
#define ZXN_RGB333_FBM_CYAN  __ZXN_RGB333_FBM_CYAN
#define ZXN_RGB333_FBM_YELLOW  __ZXN_RGB333_FBM_YELLOW
#define ZXN_RGB333_FBM_RED  __ZXN_RGB333_FBM_RED
#define ZXN_RGB333_FBM_PURPLE  __ZXN_RGB333_FBM_PURPLE

// Google
// http://www.color-hex.com/color-palette/1872

#define ZXN_RGB332_GOOGLE_BLACK  __ZXN_RGB332_GOOGLE_BLACK
#define ZXN_RGB332_GOOGLE_GREEN  __ZXN_RGB332_GOOGLE_GREEN
#define ZXN_RGB332_GOOGLE_BLUE  __ZXN_RGB332_GOOGLE_BLUE
#define ZXN_RGB332_GOOGLE_RED  __ZXN_RGB332_GOOGLE_RED
#define ZXN_RGB332_GOOGLE_YELLOW  __ZXN_RGB332_GOOGLE_YELLOW
#define ZXN_RGB332_GOOGLE_WHITE  __ZXN_RGB332_GOOGLE_WHITE

#define ZXN_RGB333_GOOGLE_BLACK  __ZXN_RGB333_GOOGLE_BLACK
#define ZXN_RGB333_GOOGLE_GREEN  __ZXN_RGB333_GOOGLE_GREEN
#define ZXN_RGB333_GOOGLE_BLUE  __ZXN_RGB333_GOOGLE_BLUE
#define ZXN_RGB333_GOOGLE_RED  __ZXN_RGB333_GOOGLE_RED
#define ZXN_RGB333_GOOGLE_YELLOW  __ZXN_RGB333_GOOGLE_YELLOW
#define ZXN_RGB333_GOOGLE_WHITE  __ZXN_RGB333_GOOGLE_WHITE

// YouTube
// http://www.color-hex.com/color-palette/2017

#define ZXN_RGB332_YOUTUBE_RED  __ZXN_RGB332_YOUTUBE_RED
#define ZXN_RGB332_YOUTUBE_BLUE  __ZXN_RGB332_YOUTUBE_BLUE
#define ZXN_RGB332_YOUTUBE_GREEN  __ZXN_RGB332_YOUTUBE_GREEN
#define ZXN_RGB332_YOUTUBE_GREY  __ZXN_RGB332_YOUTUBE_GREY
#define ZXN_RGB332_YOUTUBE_WHITE  __ZXN_RGB332_YOUTUBE_WHITE

#define ZXN_RGB333_YOUTUBE_RED  __ZXN_RGB333_YOUTUBE_RED
#define ZXN_RGB333_YOUTUBE_BLUE  __ZXN_RGB333_YOUTUBE_BLUE
#define ZXN_RGB333_YOUTUBE_GREEN  __ZXN_RGB333_YOUTUBE_GREEN
#define ZXN_RGB333_YOUTUBE_GREY  __ZXN_RGB333_YOUTUBE_GREY
#define ZXN_RGB333_YOUTUBE_WHITE  __ZXN_RGB333_YOUTUBE_WHITE

// Instagram
// http://www.color-hex.com/color-palette/10610

#define ZXN_RGB332_INSTAGRAM_BROWN  __ZXN_RGB332_INSTAGRAM_BROWN
#define ZXN_RGB332_INSTAGRAM_RED  __ZXN_RGB332_INSTAGRAM_RED
#define ZXN_RGB332_INSTAGRAM_YELLOW  __ZXN_RGB332_INSTAGRAM_YELLOW
#define ZXN_RGB332_INSTAGRAM_GREEN  __ZXN_RGB332_INSTAGRAM_GREEN
#define ZXN_RGB332_INSTAGRAM_BLUE  __ZXN_RGB332_INSTAGRAM_BLUE

#define ZXN_RGB333_INSTAGRAM_BROWN  __ZXN_RGB333_INSTAGRAM_BROWN
#define ZXN_RGB333_INSTAGRAM_RED  __ZXN_RGB333_INSTAGRAM_RED
#define ZXN_RGB333_INSTAGRAM_YELLOW  __ZXN_RGB333_INSTAGRAM_YELLOW
#define ZXN_RGB333_INSTAGRAM_GREEN  __ZXN_RGB333_INSTAGRAM_GREEN
#define ZXN_RGB333_INSTAGRAM_BLUE  __ZXN_RGB333_INSTAGRAM_BLUE

// COMPUTERS

// ZX Spectrum
// https://sites.google.com/site/ulaplus/

#define ZXN_RGB332_ZX_BLACK  __ZXN_RGB332_ZX_BLACK
#define ZXN_RGB332_ZX_BLUE  __ZXN_RGB332_ZX_BLUE
#define ZXN_RGB332_ZX_RED  __ZXN_RGB332_ZX_RED
#define ZXN_RGB332_ZX_MAGENTA  __ZXN_RGB332_ZX_MAGENTA
#define ZXN_RGB332_ZX_GREEN  __ZXN_RGB332_ZX_GREEN
#define ZXN_RGB332_ZX_CYAN  __ZXN_RGB332_ZX_CYAN
#define ZXN_RGB332_ZX_YELLOW  __ZXN_RGB332_ZX_YELLOW
#define ZXN_RGB332_ZX_WHITE  __ZXN_RGB332_ZX_WHITE
#define ZXN_RGB332_ZX_BRIGHT_BLACK  __ZXN_RGB332_ZX_BRIGHT_BLACK
#define ZXN_RGB332_ZX_BRIGHT_BLUE  __ZXN_RGB332_ZX_BRIGHT_BLUE
#define ZXN_RGB332_ZX_BRIGHT_RED  __ZXN_RGB332_ZX_BRIGHT_RED
#define ZXN_RGB332_ZX_BRIGHT_MAGENTA  __ZXN_RGB332_ZX_BRIGHT_MAGENTA
#define ZXN_RGB332_ZX_BRIGHT_GREEN  __ZXN_RGB332_ZX_BRIGHT_GREEN
#define ZXN_RGB332_ZX_BRIGHT_CYAN  __ZXN_RGB332_ZX_BRIGHT_CYAN
#define ZXN_RGB332_ZX_BRIGHT_YELLOW  __ZXN_RGB332_ZX_BRIGHT_YELLOW
#define ZXN_RGB332_ZX_BRIGHT_WHITE  __ZXN_RGB332_ZX_BRIGHT_WHITE

// https://en.wikipedia.org/wiki/ZX_Spectrum_graphic_modes

#define ZXN_RGB333_ZX_BLACK  __ZXN_RGB333_ZX_BLACK
#define ZXN_RGB333_ZX_BLUE  __ZXN_RGB333_ZX_BLUE
#define ZXN_RGB333_ZX_RED  __ZXN_RGB333_ZX_RED
#define ZXN_RGB333_ZX_MAGENTA  __ZXN_RGB333_ZX_MAGENTA
#define ZXN_RGB333_ZX_GREEN  __ZXN_RGB333_ZX_GREEN
#define ZXN_RGB333_ZX_CYAN  __ZXN_RGB333_ZX_CYAN
#define ZXN_RGB333_ZX_YELLOW  __ZXN_RGB333_ZX_YELLOW
#define ZXN_RGB333_ZX_WHITE  __ZXN_RGB333_ZX_WHITE
#define ZXN_RGB333_ZX_BRIGHT_BLACK  __ZXN_RGB333_ZX_BRIGHT_BLACK
#define ZXN_RGB333_ZX_BRIGHT_BLUE  __ZXN_RGB333_ZX_BRIGHT_BLUE
#define ZXN_RGB333_ZX_BRIGHT_RED  __ZXN_RGB333_ZX_BRIGHT_RED
#define ZXN_RGB333_ZX_BRIGHT_MAGENTA  __ZXN_RGB333_ZX_BRIGHT_MAGENTA
#define ZXN_RGB333_ZX_BRIGHT_GREEN  __ZXN_RGB333_ZX_BRIGHT_GREEN
#define ZXN_RGB333_ZX_BRIGHT_CYAN  __ZXN_RGB333_ZX_BRIGHT_CYAN
#define ZXN_RGB333_ZX_BRIGHT_YELLOW  __ZXN_RGB333_ZX_BRIGHT_YELLOW
#define ZXN_RGB333_ZX_BRIGHT_WHITE  __ZXN_RGB333_ZX_BRIGHT_WHITE

// Commodore 64
// https://sites.google.com/site/ulaplus/

#define ZXN_RGB332_C64_BLACK  __ZXN_RGB332_C64_BLACK
#define ZXN_RGB332_C64_WHITE  __ZXN_RGB332_C64_WHITE
#define ZXN_RGB332_C64_RED  __ZXN_RGB332_C64_RED
#define ZXN_RGB332_C64_CYAN  __ZXN_RGB332_C64_CYAN
#define ZXN_RGB332_C64_VIOLET  __ZXN_RGB332_C64_VIOLET
#define ZXN_RGB332_C64_GREEN  __ZXN_RGB332_C64_GREEN
#define ZXN_RGB332_C64_BLUE  __ZXN_RGB332_C64_BLUE
#define ZXN_RGB332_C64_YELLOW  __ZXN_RGB332_C64_YELLOW
#define ZXN_RGB332_C64_ORANGE  __ZXN_RGB332_C64_ORANGE
#define ZXN_RGB332_C64_BROWN  __ZXN_RGB332_C64_BROWN
#define ZXN_RGB332_C64_LIGHTRED  __ZXN_RGB332_C64_LIGHTRED
#define ZXN_RGB332_C64_DARKGRAY  __ZXN_RGB332_C64_DARKGRAY
#define ZXN_RGB332_C64_GRAY  __ZXN_RGB332_C64_GRAY
#define ZXN_RGB332_C64_LIGHTGREEN  __ZXN_RGB332_C64_LIGHTGREEN
#define ZXN_RGB332_C64_LIGHTBLUE  __ZXN_RGB332_C64_LIGHTBLUE
#define ZXN_RGB332_C64_LIGHTGRAY  __ZXN_RGB332_C64_LIGHTGRAY

// https://www.c64-wiki.com/wiki/Color

#define ZXN_RGB333_C64_BLACK  __ZXN_RGB333_C64_BLACK
#define ZXN_RGB333_C64_WHITE  __ZXN_RGB333_C64_WHITE
#define ZXN_RGB333_C64_RED  __ZXN_RGB333_C64_RED
#define ZXN_RGB333_C64_CYAN  __ZXN_RGB333_C64_CYAN
#define ZXN_RGB333_C64_VIOLET  __ZXN_RGB333_C64_VIOLET
#define ZXN_RGB333_C64_GREEN  __ZXN_RGB333_C64_GREEN
#define ZXN_RGB333_C64_BLUE  __ZXN_RGB333_C64_BLUE
#define ZXN_RGB333_C64_YELLOW  __ZXN_RGB333_C64_YELLOW
#define ZXN_RGB333_C64_ORANGE  __ZXN_RGB333_C64_ORANGE
#define ZXN_RGB333_C64_BROWN  __ZXN_RGB333_C64_BROWN
#define ZXN_RGB333_C64_LIGHTRED  __ZXN_RGB333_C64_LIGHTRED
#define ZXN_RGB333_C64_DARKGRAY  __ZXN_RGB333_C64_DARKGRAY
#define ZXN_RGB333_C64_GRAY  __ZXN_RGB333_C64_GRAY
#define ZXN_RGB333_C64_LIGHTGREEN  __ZXN_RGB333_C64_LIGHTGREEN
#define ZXN_RGB333_C64_LIGHTBLUE  __ZXN_RGB333_C64_LIGHTBLUE
#define ZXN_RGB333_C64_LIGHTGRAY  __ZXN_RGB333_C64_LIGHTGRAY

// Apple II
// https://mrob.com/pub/xapple2/colors.html

#define ZXN_RGB332_APPLEII_BLACK  __ZXN_RGB332_APPLEII_BLACK
#define ZXN_RGB332_APPLEII_RED  __ZXN_RGB332_APPLEII_RED
#define ZXN_RGB332_APPLEII_DBLUE  __ZXN_RGB332_APPLEII_DBLUE
#define ZXN_RGB332_APPLEII_PURPLE  __ZXN_RGB332_APPLEII_PURPLE
#define ZXN_RGB332_APPLEII_DGREEN  __ZXN_RGB332_APPLEII_DGREEN
#define ZXN_RGB332_APPLEII_GRAY  __ZXN_RGB332_APPLEII_GRAY
#define ZXN_RGB332_APPLEII_MBLUE  __ZXN_RGB332_APPLEII_MBLUE
#define ZXN_RGB332_APPLEII_LBLUE  __ZXN_RGB332_APPLEII_LBLUE
#define ZXN_RGB332_APPLEII_BROWN  __ZXN_RGB332_APPLEII_BROWN
#define ZXN_RGB332_APPLEII_ORANGE  __ZXN_RGB332_APPLEII_ORANGE
#define ZXN_RGB332_APPLEII_PINK  __ZXN_RGB332_APPLEII_PINK
#define ZXN_RGB332_APPLEII_LGREEN  __ZXN_RGB332_APPLEII_LGREEN
#define ZXN_RGB332_APPLEII_YELLOW  __ZXN_RGB332_APPLEII_YELLOW
#define ZXN_RGB332_APPLEII_AQUA  __ZXN_RGB332_APPLEII_AQUA
#define ZXN_RGB332_APPLEII_WHITE  __ZXN_RGB332_APPLEII_WHITE

#define ZXN_RGB333_APPLEII_BLACK  __ZXN_RGB333_APPLEII_BLACK
#define ZXN_RGB333_APPLEII_RED  __ZXN_RGB333_APPLEII_RED
#define ZXN_RGB333_APPLEII_DBLUE  __ZXN_RGB333_APPLEII_DBLUE
#define ZXN_RGB333_APPLEII_PURPLE  __ZXN_RGB333_APPLEII_PURPLE
#define ZXN_RGB333_APPLEII_DGREEN  __ZXN_RGB333_APPLEII_DGREEN
#define ZXN_RGB333_APPLEII_GRAY  __ZXN_RGB333_APPLEII_GRAY
#define ZXN_RGB333_APPLEII_MBLUE  __ZXN_RGB333_APPLEII_MBLUE
#define ZXN_RGB333_APPLEII_LBLUE  __ZXN_RGB333_APPLEII_LBLUE
#define ZXN_RGB333_APPLEII_BROWN  __ZXN_RGB333_APPLEII_BROWN
#define ZXN_RGB333_APPLEII_ORANGE  __ZXN_RGB333_APPLEII_ORANGE
#define ZXN_RGB333_APPLEII_PINK  __ZXN_RGB333_APPLEII_PINK
#define ZXN_RGB333_APPLEII_LGREEN  __ZXN_RGB333_APPLEII_LGREEN
#define ZXN_RGB333_APPLEII_YELLOW  __ZXN_RGB333_APPLEII_YELLOW
#define ZXN_RGB333_APPLEII_AQUA  __ZXN_RGB333_APPLEII_AQUA
#define ZXN_RGB333_APPLEII_WHITE  __ZXN_RGB333_APPLEII_WHITE

// CONSOLES

// PICO-8 Palette
// https://lospec.com/palette-list/pico-8

#define ZXN_RGB332_PICO8_BLACK  __ZXN_RGB332_PICO8_BLACK
#define ZXN_RGB332_PICO8_GRAY  __ZXN_RGB332_PICO8_GRAY
#define ZXN_RGB332_PICO8_VIOLET  __ZXN_RGB332_PICO8_VIOLET
#define ZXN_RGB332_PICO8_LGRAY  __ZXN_RGB332_PICO8_LGRAY
#define ZXN_RGB332_PICO8_WHITE  __ZXN_RGB332_PICO8_WHITE
#define ZXN_RGB332_PICO8_PURPLE  __ZXN_RGB332_PICO8_PURPLE
#define ZXN_RGB332_PICO8_RED  __ZXN_RGB332_PICO8_RED
#define ZXN_RGB332_PICO8_PINK  __ZXN_RGB332_PICO8_PINK
#define ZXN_RGB332_PICO8_BROWN  __ZXN_RGB332_PICO8_BROWN
#define ZXN_RGB332_PICO8_GOLD  __ZXN_RGB332_PICO8_GOLD
#define ZXN_RGB332_PICO8_YELLOW  __ZXN_RGB332_PICO8_YELLOW
#define ZXN_RGB332_PICO8_SKIN  __ZXN_RGB332_PICO8_SKIN
#define ZXN_RGB332_PICO8_GREEN  __ZXN_RGB332_PICO8_GREEN
#define ZXN_RGB332_PICO8_LGREEN  __ZXN_RGB332_PICO8_LGREEN
#define ZXN_RGB332_PICO8_BLUE  __ZXN_RGB332_PICO8_BLUE
#define ZXN_RGB332_PICO8_CYAN  __ZXN_RGB332_PICO8_CYAN

#define ZXN_RGB333_PICO8_BLACK  __ZXN_RGB333_PICO8_BLACK
#define ZXN_RGB333_PICO8_GRAY  __ZXN_RGB333_PICO8_GRAY
#define ZXN_RGB333_PICO8_VIOLET  __ZXN_RGB333_PICO8_VIOLET
#define ZXN_RGB333_PICO8_LGRAY  __ZXN_RGB333_PICO8_LGRAY
#define ZXN_RGB333_PICO8_WHITE  __ZXN_RGB333_PICO8_WHITE
#define ZXN_RGB333_PICO8_PURPLE  __ZXN_RGB333_PICO8_PURPLE
#define ZXN_RGB333_PICO8_RED  __ZXN_RGB333_PICO8_RED
#define ZXN_RGB333_PICO8_PINK  __ZXN_RGB333_PICO8_PINK
#define ZXN_RGB333_PICO8_BROWN  __ZXN_RGB333_PICO8_BROWN
#define ZXN_RGB333_PICO8_GOLD  __ZXN_RGB333_PICO8_GOLD
#define ZXN_RGB333_PICO8_YELLOW  __ZXN_RGB333_PICO8_YELLOW
#define ZXN_RGB333_PICO8_SKIN  __ZXN_RGB333_PICO8_SKIN
#define ZXN_RGB333_PICO8_GREEN  __ZXN_RGB333_PICO8_GREEN
#define ZXN_RGB333_PICO8_LGREEN  __ZXN_RGB333_PICO8_LGREEN
#define ZXN_RGB333_PICO8_BLUE  __ZXN_RGB333_PICO8_BLUE
#define ZXN_RGB333_PICO8_CYAN  __ZXN_RGB333_PICO8_CYAN

// Arcade Standard 29
// https://lospec.com/palette-list/arcade-standard-29

#define ZXN_RGB332_ARCADE29_WHITE  __ZXN_RGB332_ARCADE29_WHITE
#define ZXN_RGB332_ARCADE29_PINKROSE  __ZXN_RGB332_ARCADE29_PINKROSE
#define ZXN_RGB332_ARCADE29_BRICK  __ZXN_RGB332_ARCADE29_BRICK
#define ZXN_RGB332_ARCADE29_YELLOW  __ZXN_RGB332_ARCADE29_YELLOW
#define ZXN_RGB332_ARCADE29_ORANGE  __ZXN_RGB332_ARCADE29_ORANGE
#define ZXN_RGB332_ARCADE29_SKIN  __ZXN_RGB332_ARCADE29_SKIN
#define ZXN_RGB332_ARCADE29_DSKIN  __ZXN_RGB332_ARCADE29_DSKIN
#define ZXN_RGB332_ARCADE29_REDBROWN  __ZXN_RGB332_ARCADE29_REDBROWN
#define ZXN_RGB332_ARCADE29_MAROON  __ZXN_RGB332_ARCADE29_MAROON
#define ZXN_RGB332_ARCADE29_LGREEN  __ZXN_RGB332_ARCADE29_LGREEN
#define ZXN_RGB332_ARCADE29_GREEN  __ZXN_RGB332_ARCADE29_GREEN
#define ZXN_RGB332_ARCADE29_TEAL  __ZXN_RGB332_ARCADE29_TEAL
#define ZXN_RGB332_ARCADE29_BCYAN  __ZXN_RGB332_ARCADE29_BCYAN
#define ZXN_RGB332_ARCADE29_LTEAL  __ZXN_RGB332_ARCADE29_LTEAL
#define ZXN_RGB332_ARCADE29_CYAN  __ZXN_RGB332_ARCADE29_CYAN
#define ZXN_RGB332_ARCADE29_LBLUE  __ZXN_RGB332_ARCADE29_LBLUE
#define ZXN_RGB332_ARCADE29_BLUE  __ZXN_RGB332_ARCADE29_BLUE
#define ZXN_RGB332_ARCADE29_DBLUE  __ZXN_RGB332_ARCADE29_DBLUE
#define ZXN_RGB332_ARCADE29_LPINK  __ZXN_RGB332_ARCADE29_LPINK
#define ZXN_RGB332_ARCADE29_PURPLE  __ZXN_RGB332_ARCADE29_PURPLE
#define ZXN_RGB332_ARCADE29_PALEPINK  __ZXN_RGB332_ARCADE29_PALEPINK
#define ZXN_RGB332_ARCADE29_PINK  __ZXN_RGB332_ARCADE29_PINK
#define ZXN_RGB332_ARCADE29_BLACK  __ZXN_RGB332_ARCADE29_BLACK
#define ZXN_RGB332_ARCADE29_LGRAY  __ZXN_RGB332_ARCADE29_LGRAY
#define ZXN_RGB332_ARCADE29_GRAY  __ZXN_RGB332_ARCADE29_GRAY
#define ZXN_RGB332_ARCADE29_BLUEGRAY  __ZXN_RGB332_ARCADE29_BLUEGRAY
#define ZXN_RGB332_ARCADE29_BEIGE  __ZXN_RGB332_ARCADE29_BEIGE
#define ZXN_RGB332_ARCADE29_LBROWN  __ZXN_RGB332_ARCADE29_LBROWN
#define ZXN_RGB332_ARCADE29_BROWN  __ZXN_RGB332_ARCADE29_BROWN

#define ZXN_RGB333_ARCADE29_WHITE  __ZXN_RGB333_ARCADE29_WHITE
#define ZXN_RGB333_ARCADE29_PINKROSE  __ZXN_RGB333_ARCADE29_PINKROSE
#define ZXN_RGB333_ARCADE29_BRICK  __ZXN_RGB333_ARCADE29_BRICK
#define ZXN_RGB333_ARCADE29_YELLOW  __ZXN_RGB333_ARCADE29_YELLOW
#define ZXN_RGB333_ARCADE29_ORANGE  __ZXN_RGB333_ARCADE29_ORANGE
#define ZXN_RGB333_ARCADE29_SKIN  __ZXN_RGB333_ARCADE29_SKIN
#define ZXN_RGB333_ARCADE29_DSKIN  __ZXN_RGB333_ARCADE29_DSKIN
#define ZXN_RGB333_ARCADE29_REDBROWN  __ZXN_RGB333_ARCADE29_REDBROWN
#define ZXN_RGB333_ARCADE29_MAROON  __ZXN_RGB333_ARCADE29_MAROON
#define ZXN_RGB333_ARCADE29_LGREEN  __ZXN_RGB333_ARCADE29_LGREEN
#define ZXN_RGB333_ARCADE29_GREEN  __ZXN_RGB333_ARCADE29_GREEN
#define ZXN_RGB333_ARCADE29_TEAL  __ZXN_RGB333_ARCADE29_TEAL
#define ZXN_RGB333_ARCADE29_BCYAN  __ZXN_RGB333_ARCADE29_BCYAN
#define ZXN_RGB333_ARCADE29_LTEAL  __ZXN_RGB333_ARCADE29_LTEAL
#define ZXN_RGB333_ARCADE29_CYAN  __ZXN_RGB333_ARCADE29_CYAN
#define ZXN_RGB333_ARCADE29_LBLUE  __ZXN_RGB333_ARCADE29_LBLUE
#define ZXN_RGB333_ARCADE29_BLUE  __ZXN_RGB333_ARCADE29_BLUE
#define ZXN_RGB333_ARCADE29_DBLUE  __ZXN_RGB333_ARCADE29_DBLUE
#define ZXN_RGB333_ARCADE29_LPINK  __ZXN_RGB333_ARCADE29_LPINK
#define ZXN_RGB333_ARCADE29_PURPLE  __ZXN_RGB333_ARCADE29_PURPLE
#define ZXN_RGB333_ARCADE29_PALEPINK  __ZXN_RGB333_ARCADE29_PALEPINK
#define ZXN_RGB333_ARCADE29_PINK  __ZXN_RGB333_ARCADE29_PINK
#define ZXN_RGB333_ARCADE29_BLACK  __ZXN_RGB333_ARCADE29_BLACK
#define ZXN_RGB333_ARCADE29_LGRAY  __ZXN_RGB333_ARCADE29_LGRAY
#define ZXN_RGB333_ARCADE29_GRAY  __ZXN_RGB333_ARCADE29_GRAY
#define ZXN_RGB333_ARCADE29_BLUEGRAY  __ZXN_RGB333_ARCADE29_BLUEGRAY
#define ZXN_RGB333_ARCADE29_BEIGE  __ZXN_RGB333_ARCADE29_BEIGE
#define ZXN_RGB333_ARCADE29_LBROWN  __ZXN_RGB333_ARCADE29_LBROWN
#define ZXN_RGB333_ARCADE29_BROWN  __ZXN_RGB333_ARCADE29_BROWN

// Nintendo Gameboy BGB Emulator
// https://lospec.com/palette-list/nintendo-gameboy-bgb

#define ZXN_RGB332_GAMEBOY_0  __ZXN_RGB332_GAMEBOY_0
#define ZXN_RGB332_GAMEBOY_1  __ZXN_RGB332_GAMEBOY_1
#define ZXN_RGB332_GAMEBOY_2  __ZXN_RGB332_GAMEBOY_2
#define ZXN_RGB332_GAMEBOY_3  __ZXN_RGB332_GAMEBOY_3

#define ZXN_RGB333_GAMEBOY_0  __ZXN_RGB333_GAMEBOY_0
#define ZXN_RGB333_GAMEBOY_1  __ZXN_RGB333_GAMEBOY_1
#define ZXN_RGB333_GAMEBOY_2  __ZXN_RGB333_GAMEBOY_2
#define ZXN_RGB333_GAMEBOY_3  __ZXN_RGB333_GAMEBOY_3

// RESTRICTED PALETTES FOR GAMES

// Games ZXN by Retro
// https://www.specnext.com/forum/viewtopic.php?f=7&t=286#p981

#define ZXN_RGB332_GZXNR_BLUE_0  __ZXN_RGB332_GZXNR_BLUE_0
#define ZXN_RGB332_GZXNR_BLUE_1  __ZXN_RGB332_GZXNR_BLUE_1
#define ZXN_RGB332_GZXNR_BLUE_2  __ZXN_RGB332_GZXNR_BLUE_2
#define ZXN_RGB332_GZXNR_BLUE_3  __ZXN_RGB332_GZXNR_BLUE_3
#define ZXN_RGB332_GZXNR_BLUE_4  __ZXN_RGB332_GZXNR_BLUE_4

#define ZXN_RGB332_GZXNR_RED_0  __ZXN_RGB332_GZXNR_RED_0
#define ZXN_RGB332_GZXNR_RED_1  __ZXN_RGB332_GZXNR_RED_1
#define ZXN_RGB332_GZXNR_RED_2  __ZXN_RGB332_GZXNR_RED_2
#define ZXN_RGB332_GZXNR_RED_3  __ZXN_RGB332_GZXNR_RED_3
#define ZXN_RGB332_GZXNR_RED_4  __ZXN_RGB332_GZXNR_RED_4

#define ZXN_RGB332_GZXNR_PURPLE_0  __ZXN_RGB332_GZXNR_PURPLE_0
#define ZXN_RGB332_GZXNR_PURPLE_1  __ZXN_RGB332_GZXNR_PURPLE_1
#define ZXN_RGB332_GZXNR_PURPLE_2  __ZXN_RGB332_GZXNR_PURPLE_2
#define ZXN_RGB332_GZXNR_PURPLE_3  __ZXN_RGB332_GZXNR_PURPLE_3
#define ZXN_RGB332_GZXNR_PURPLE_4  __ZXN_RGB332_GZXNR_PURPLE_4

#define ZXN_RGB332_GZXNR_GREEN_0  __ZXN_RGB332_GZXNR_GREEN_0
#define ZXN_RGB332_GZXNR_GREEN_1  __ZXN_RGB332_GZXNR_GREEN_1
#define ZXN_RGB332_GZXNR_GREEN_2  __ZXN_RGB332_GZXNR_GREEN_2
#define ZXN_RGB332_GZXNR_GREEN_3  __ZXN_RGB332_GZXNR_GREEN_3
#define ZXN_RGB332_GZXNR_GREEN_4  __ZXN_RGB332_GZXNR_GREEN_4

#define ZXN_RGB332_GZXNR_CYAN_0  __ZXN_RGB332_GZXNR_CYAN_0
#define ZXN_RGB332_GZXNR_CYAN_1  __ZXN_RGB332_GZXNR_CYAN_1
#define ZXN_RGB332_GZXNR_CYAN_2  __ZXN_RGB332_GZXNR_CYAN_2
#define ZXN_RGB332_GZXNR_CYAN_3  __ZXN_RGB332_GZXNR_CYAN_3
#define ZXN_RGB332_GZXNR_CYAN_4  __ZXN_RGB332_GZXNR_CYAN_4

#define ZXN_RGB332_GZXNR_YELLOW_0  __ZXN_RGB332_GZXNR_YELLOW_0
#define ZXN_RGB332_GZXNR_YELLOW_1  __ZXN_RGB332_GZXNR_YELLOW_1
#define ZXN_RGB332_GZXNR_YELLOW_2  __ZXN_RGB332_GZXNR_YELLOW_2
#define ZXN_RGB332_GZXNR_YELLOW_3  __ZXN_RGB332_GZXNR_YELLOW_3
#define ZXN_RGB332_GZXNR_YELLOW_4  __ZXN_RGB332_GZXNR_YELLOW_4

#define ZXN_RGB332_GZXNR_BLACK  __ZXN_RGB332_GZXNR_BLACK
#define ZXN_RGB332_GZXNR_GRAY_0  __ZXN_RGB332_GZXNR_GRAY_0
#define ZXN_RGB332_GZXNR_GRAY_1  __ZXN_RGB332_GZXNR_GRAY_1
#define ZXN_RGB332_GZXNR_WHITE  __ZXN_RGB332_GZXNR_WHITE

#define ZXN_RGB333_GZXNR_BLUE_0  __ZXN_RGB333_GZXNR_BLUE_0
#define ZXN_RGB333_GZXNR_BLUE_1  __ZXN_RGB333_GZXNR_BLUE_1
#define ZXN_RGB333_GZXNR_BLUE_2  __ZXN_RGB333_GZXNR_BLUE_2
#define ZXN_RGB333_GZXNR_BLUE_3  __ZXN_RGB333_GZXNR_BLUE_3
#define ZXN_RGB333_GZXNR_BLUE_4  __ZXN_RGB333_GZXNR_BLUE_4

#define ZXN_RGB333_GZXNR_RED_0  __ZXN_RGB333_GZXNR_RED_0
#define ZXN_RGB333_GZXNR_RED_1  __ZXN_RGB333_GZXNR_RED_1
#define ZXN_RGB333_GZXNR_RED_2  __ZXN_RGB333_GZXNR_RED_2
#define ZXN_RGB333_GZXNR_RED_3  __ZXN_RGB333_GZXNR_RED_3
#define ZXN_RGB333_GZXNR_RED_4  __ZXN_RGB333_GZXNR_RED_4

#define ZXN_RGB333_GZXNR_PURPLE_0  __ZXN_RGB333_GZXNR_PURPLE_0
#define ZXN_RGB333_GZXNR_PURPLE_1  __ZXN_RGB333_GZXNR_PURPLE_1
#define ZXN_RGB333_GZXNR_PURPLE_2  __ZXN_RGB333_GZXNR_PURPLE_2
#define ZXN_RGB333_GZXNR_PURPLE_3  __ZXN_RGB333_GZXNR_PURPLE_3
#define ZXN_RGB333_GZXNR_PURPLE_4  __ZXN_RGB333_GZXNR_PURPLE_4

#define ZXN_RGB333_GZXNR_GREEN_0  __ZXN_RGB333_GZXNR_GREEN_0
#define ZXN_RGB333_GZXNR_GREEN_1  __ZXN_RGB333_GZXNR_GREEN_1
#define ZXN_RGB333_GZXNR_GREEN_2  __ZXN_RGB333_GZXNR_GREEN_2
#define ZXN_RGB333_GZXNR_GREEN_3  __ZXN_RGB333_GZXNR_GREEN_3
#define ZXN_RGB333_GZXNR_GREEN_4  __ZXN_RGB333_GZXNR_GREEN_4

#define ZXN_RGB333_GZXNR_CYAN_0  __ZXN_RGB333_GZXNR_CYAN_0
#define ZXN_RGB333_GZXNR_CYAN_1  __ZXN_RGB333_GZXNR_CYAN_1
#define ZXN_RGB333_GZXNR_CYAN_2  __ZXN_RGB333_GZXNR_CYAN_2
#define ZXN_RGB333_GZXNR_CYAN_3  __ZXN_RGB333_GZXNR_CYAN_3
#define ZXN_RGB333_GZXNR_CYAN_4  __ZXN_RGB333_GZXNR_CYAN_4

#define ZXN_RGB333_GZXNR_YELLOW_0  __ZXN_RGB333_GZXNR_YELLOW_0
#define ZXN_RGB333_GZXNR_YELLOW_1  __ZXN_RGB333_GZXNR_YELLOW_1
#define ZXN_RGB333_GZXNR_YELLOW_2  __ZXN_RGB333_GZXNR_YELLOW_2
#define ZXN_RGB333_GZXNR_YELLOW_3  __ZXN_RGB333_GZXNR_YELLOW_3
#define ZXN_RGB333_GZXNR_YELLOW_4  __ZXN_RGB333_GZXNR_YELLOW_4

#define ZXN_RGB333_GZXNR_BLACK  __ZXN_RGB333_GZXNR_BLACK
#define ZXN_RGB333_GZXNR_GRAY_0  __ZXN_RGB333_GZXNR_GRAY_0
#define ZXN_RGB333_GZXNR_GRAY_1  __ZXN_RGB333_GZXNR_GRAY_1
#define ZXN_RGB333_GZXNR_WHITE  __ZXN_RGB333_GZXNR_WHITE

// EGA-COM Extended
// https://lospec.com/palette-list/ega-com-extended

#define ZXN_RGB332_EGACOM_BLACK  __ZXN_RGB332_EGACOM_BLACK
#define ZXN_RGB332_EGACOM_GRAY  __ZXN_RGB332_EGACOM_GRAY
#define ZXN_RGB332_EGACOM_LGRAY  __ZXN_RGB332_EGACOM_LGRAY
#define ZXN_RGB332_EGACOM_WHITE  __ZXN_RGB332_EGACOM_WHITE
#define ZXN_RGB332_EGACOM_MAROON  __ZXN_RGB332_EGACOM_MAROON
#define ZXN_RGB332_EGACOM_PINKROSE  __ZXN_RGB332_EGACOM_PINKROSE
#define ZXN_RGB332_EGACOM_GOLD  __ZXN_RGB332_EGACOM_GOLD
#define ZXN_RGB332_EGACOM_YELLOW  __ZXN_RGB332_EGACOM_YELLOW
#define ZXN_RGB332_EGACOM_BROWN  __ZXN_RGB332_EGACOM_BROWN
#define ZXN_RGB332_EGACOM_LBROWN  __ZXN_RGB332_EGACOM_LBROWN
#define ZXN_RGB332_EGACOM_TEAL  __ZXN_RGB332_EGACOM_TEAL
#define ZXN_RGB332_EGACOM_GREEN  __ZXN_RGB332_EGACOM_GREEN
#define ZXN_RGB332_EGACOM_BLUE  __ZXN_RGB332_EGACOM_BLUE
#define ZXN_RGB332_EGACOM_LBLUE  __ZXN_RGB332_EGACOM_LBLUE
#define ZXN_RGB332_EGACOM_PURPLE  __ZXN_RGB332_EGACOM_PURPLE
#define ZXN_RGB332_EGACOM_SAND  __ZXN_RGB332_EGACOM_SAND
#define ZXN_RGB332_EGACOM_DGREEN  __ZXN_RGB332_EGACOM_DGREEN
#define ZXN_RGB332_EGACOM_CYAN  __ZXN_RGB332_EGACOM_CYAN
#define ZXN_RGB332_EGACOM_VIOLET  __ZXN_RGB332_EGACOM_VIOLET
#define ZXN_RGB332_EGACOM_PINK  __ZXN_RGB332_EGACOM_PINK

#define ZXN_RGB333_EGACOM_BLACK  __ZXN_RGB333_EGACOM_BLACK
#define ZXN_RGB333_EGACOM_GRAY  __ZXN_RGB333_EGACOM_GRAY
#define ZXN_RGB333_EGACOM_LGRAY  __ZXN_RGB333_EGACOM_LGRAY
#define ZXN_RGB333_EGACOM_WHITE  __ZXN_RGB333_EGACOM_WHITE
#define ZXN_RGB333_EGACOM_MAROON  __ZXN_RGB333_EGACOM_MAROON
#define ZXN_RGB333_EGACOM_PINKROSE  __ZXN_RGB333_EGACOM_PINKROSE
#define ZXN_RGB333_EGACOM_GOLD  __ZXN_RGB333_EGACOM_GOLD
#define ZXN_RGB333_EGACOM_YELLOW  __ZXN_RGB333_EGACOM_YELLOW
#define ZXN_RGB333_EGACOM_BROWN  __ZXN_RGB333_EGACOM_BROWN
#define ZXN_RGB333_EGACOM_LBROWN  __ZXN_RGB333_EGACOM_LBROWN
#define ZXN_RGB333_EGACOM_TEAL  __ZXN_RGB333_EGACOM_TEAL
#define ZXN_RGB333_EGACOM_GREEN  __ZXN_RGB333_EGACOM_GREEN
#define ZXN_RGB333_EGACOM_BLUE  __ZXN_RGB333_EGACOM_BLUE
#define ZXN_RGB333_EGACOM_LBLUE  __ZXN_RGB333_EGACOM_LBLUE
#define ZXN_RGB333_EGACOM_PURPLE  __ZXN_RGB333_EGACOM_PURPLE
#define ZXN_RGB333_EGACOM_SAND  __ZXN_RGB333_EGACOM_SAND
#define ZXN_RGB333_EGACOM_DGREEN  __ZXN_RGB333_EGACOM_DGREEN
#define ZXN_RGB333_EGACOM_CYAN  __ZXN_RGB333_EGACOM_CYAN
#define ZXN_RGB333_EGACOM_VIOLET  __ZXN_RGB333_EGACOM_VIOLET
#define ZXN_RGB333_EGACOM_PINK  __ZXN_RGB333_EGACOM_PINK

// Games MSX 
// https://www.msx.org/wiki/Setting_up_a_palette

#define ZXN_RGB332_GMSX_BLACK  __ZXN_RGB332_GMSX_BLACK
#define ZXN_RGB332_GMSX_GRAY  __ZXN_RGB332_GMSX_GRAY
#define ZXN_RGB332_GMSX_SILVER  __ZXN_RGB332_GMSX_SILVER
#define ZXN_RGB332_GMSX_DARK_TEAL  __ZXN_RGB332_GMSX_DARK_TEAL
#define ZXN_RGB332_GMSX_GREEN  __ZXN_RGB332_GMSX_GREEN
#define ZXN_RGB332_GMSX_GREENYELLOW  __ZXN_RGB332_GMSX_GREENYELLOW
#define ZXN_RGB332_GMSX_MAROON  __ZXN_RGB332_GMSX_MAROON
#define ZXN_RGB332_GMSX_SIENNA  __ZXN_RGB332_GMSX_SIENNA
#define ZXN_RGB332_GMSX_SANDYBROWN  __ZXN_RGB332_GMSX_SANDYBROWN
#define ZXN_RGB332_GMSX_KHAKI  __ZXN_RGB332_GMSX_KHAKI
#define ZXN_RGB332_GMSX_WHITE  __ZXN_RGB332_GMSX_WHITE
#define ZXN_RGB332_GMSX_SKYBLUE  __ZXN_RGB332_GMSX_SKYBLUE
#define ZXN_RGB332_GMSX_SLATEBLUE  __ZXN_RGB332_GMSX_SLATEBLUE
#define ZXN_RGB332_GMSX_BLUE  __ZXN_RGB332_GMSX_BLUE

#define ZXN_RGB333_GMSX_BLACK  __ZXN_RGB333_GMSX_BLACK
#define ZXN_RGB333_GMSX_GRAY  __ZXN_RGB333_GMSX_GRAY
#define ZXN_RGB333_GMSX_SILVER  __ZXN_RGB333_GMSX_SILVER
#define ZXN_RGB333_GMSX_DARK_TEAL  __ZXN_RGB333_GMSX_DARK_TEAL
#define ZXN_RGB333_GMSX_GREEN  __ZXN_RGB333_GMSX_GREEN
#define ZXN_RGB333_GMSX_GREENYELLOW  __ZXN_RGB333_GMSX_GREENYELLOW
#define ZXN_RGB333_GMSX_MAROON  __ZXN_RGB333_GMSX_MAROON
#define ZXN_RGB333_GMSX_SIENNA  __ZXN_RGB333_GMSX_SIENNA
#define ZXN_RGB333_GMSX_SANDYBROWN  __ZXN_RGB333_GMSX_SANDYBROWN
#define ZXN_RGB333_GMSX_KHAKI  __ZXN_RGB333_GMSX_KHAKI
#define ZXN_RGB333_GMSX_WHITE  __ZXN_RGB333_GMSX_WHITE
#define ZXN_RGB333_GMSX_SKYBLUE  __ZXN_RGB333_GMSX_SKYBLUE
#define ZXN_RGB333_GMSX_SLATEBLUE  __ZXN_RGB333_GMSX_SLATEBLUE
#define ZXN_RGB333_GMSX_BLUE  __ZXN_RGB333_GMSX_BLUE

// D4D SCHEME

// http://gargy007.github.io/egui_doc/group__doxd4d__scheme__const__colors.html

#define ZXN_RGB332_D4D_DARK_BLUE  __ZXN_RGB332_D4D_DARK_BLUE
#define ZXN_RGB332_D4D_BRIGHT_BLUE  __ZXN_RGB332_D4D_BRIGHT_BLUE
#define ZXN_RGB332_D4D_BLUE  __ZXN_RGB332_D4D_BLUE
#define ZXN_RGB332_D4D_CYAN  __ZXN_RGB332_D4D_CYAN
#define ZXN_RGB332_D4D_BRIGHT_YELLOW  __ZXN_RGB332_D4D_BRIGHT_YELLOW
#define ZXN_RGB332_D4D_YELLOW  __ZXN_RGB332_D4D_YELLOW
#define ZXN_RGB332_D4D_ORANGE  __ZXN_RGB332_D4D_ORANGE
#define ZXN_RGB332_D4D_BRIGHT_RED  __ZXN_RGB332_D4D_BRIGHT_RED
#define ZXN_RGB332_D4D_RED  __ZXN_RGB332_D4D_RED
#define ZXN_RGB332_D4D_DARK_RED  __ZXN_RGB332_D4D_DARK_RED
#define ZXN_RGB332_D4D_MAGENTA  __ZXN_RGB332_D4D_MAGENTA
#define ZXN_RGB332_D4D_BRIGHT_GREEN  __ZXN_RGB332_D4D_BRIGHT_GREEN
#define ZXN_RGB332_D4D_GREEN  __ZXN_RGB332_D4D_GREEN
#define ZXN_RGB332_D4D_DARK_GREEN  __ZXN_RGB332_D4D_DARK_GREEN
#define ZXN_RGB332_D4D_BRIGHT_GREY  __ZXN_RGB332_D4D_BRIGHT_GREY
#define ZXN_RGB332_D4D_LIGHT_GREY  __ZXN_RGB332_D4D_LIGHT_GREY
#define ZXN_RGB332_D4D_GREY  __ZXN_RGB332_D4D_GREY
#define ZXN_RGB332_D4D_WHITE  __ZXN_RGB332_D4D_WHITE
#define ZXN_RGB332_D4D_BLACK  __ZXN_RGB332_D4D_BLACK

#define ZXN_RGB333_D4D_DARK_BLUE  __ZXN_RGB333_D4D_DARK_BLUE
#define ZXN_RGB333_D4D_BRIGHT_BLUE  __ZXN_RGB333_D4D_BRIGHT_BLUE
#define ZXN_RGB333_D4D_BLUE  __ZXN_RGB333_D4D_BLUE
#define ZXN_RGB333_D4D_CYAN  __ZXN_RGB333_D4D_CYAN
#define ZXN_RGB333_D4D_BRIGHT_YELLOW  __ZXN_RGB333_D4D_BRIGHT_YELLOW
#define ZXN_RGB333_D4D_YELLOW  __ZXN_RGB333_D4D_YELLOW
#define ZXN_RGB333_D4D_ORANGE  __ZXN_RGB333_D4D_ORANGE
#define ZXN_RGB333_D4D_BRIGHT_RED  __ZXN_RGB333_D4D_BRIGHT_RED
#define ZXN_RGB333_D4D_RED  __ZXN_RGB333_D4D_RED
#define ZXN_RGB333_D4D_DARK_RED  __ZXN_RGB333_D4D_DARK_RED
#define ZXN_RGB333_D4D_MAGENTA  __ZXN_RGB333_D4D_MAGENTA
#define ZXN_RGB333_D4D_BRIGHT_GREEN  __ZXN_RGB333_D4D_BRIGHT_GREEN
#define ZXN_RGB333_D4D_GREEN  __ZXN_RGB333_D4D_GREEN
#define ZXN_RGB333_D4D_DARK_GREEN  __ZXN_RGB333_D4D_DARK_GREEN
#define ZXN_RGB333_D4D_BRIGHT_GREY  __ZXN_RGB333_D4D_BRIGHT_GREY
#define ZXN_RGB333_D4D_LIGHT_GREY  __ZXN_RGB333_D4D_LIGHT_GREY
#define ZXN_RGB333_D4D_GREY  __ZXN_RGB333_D4D_GREY
#define ZXN_RGB333_D4D_WHITE  __ZXN_RGB333_D4D_WHITE
#define ZXN_RGB333_D4D_BLACK  __ZXN_RGB333_D4D_BLACK

// HTML

// https://www.w3schools.com/colors/colors_names.asp

#define ZXN_RGB332_HTML_AliceBlue  __ZXN_RGB332_HTML_AliceBlue
#define ZXN_RGB332_HTML_AntiqueWhite  __ZXN_RGB332_HTML_AntiqueWhite
#define ZXN_RGB332_HTML_Aqua  __ZXN_RGB332_HTML_Aqua
#define ZXN_RGB332_HTML_Aquamarine  __ZXN_RGB332_HTML_Aquamarine
#define ZXN_RGB332_HTML_Azure  __ZXN_RGB332_HTML_Azure
#define ZXN_RGB332_HTML_Beige  __ZXN_RGB332_HTML_Beige
#define ZXN_RGB332_HTML_Bisque  __ZXN_RGB332_HTML_Bisque
#define ZXN_RGB332_HTML_Black  __ZXN_RGB332_HTML_Black
#define ZXN_RGB332_HTML_BlanchedAlmond  __ZXN_RGB332_HTML_BlanchedAlmond
#define ZXN_RGB332_HTML_Blue  __ZXN_RGB332_HTML_Blue
#define ZXN_RGB332_HTML_BlueViolet  __ZXN_RGB332_HTML_BlueViolet
#define ZXN_RGB332_HTML_Brown  __ZXN_RGB332_HTML_Brown
#define ZXN_RGB332_HTML_BurlyWood  __ZXN_RGB332_HTML_BurlyWood
#define ZXN_RGB332_HTML_CadetBlue  __ZXN_RGB332_HTML_CadetBlue
#define ZXN_RGB332_HTML_Chartreuse  __ZXN_RGB332_HTML_Chartreuse
#define ZXN_RGB332_HTML_Chocolate  __ZXN_RGB332_HTML_Chocolate
#define ZXN_RGB332_HTML_Coral  __ZXN_RGB332_HTML_Coral
#define ZXN_RGB332_HTML_CornflowerBlue  __ZXN_RGB332_HTML_CornflowerBlue
#define ZXN_RGB332_HTML_Cornsilk  __ZXN_RGB332_HTML_Cornsilk
#define ZXN_RGB332_HTML_Crimson  __ZXN_RGB332_HTML_Crimson
#define ZXN_RGB332_HTML_Cyan  __ZXN_RGB332_HTML_Cyan
#define ZXN_RGB332_HTML_DarkBlue  __ZXN_RGB332_HTML_DarkBlue
#define ZXN_RGB332_HTML_DarkCyan  __ZXN_RGB332_HTML_DarkCyan
#define ZXN_RGB332_HTML_DarkGoldenRod  __ZXN_RGB332_HTML_DarkGoldenRod
#define ZXN_RGB332_HTML_DarkGray  __ZXN_RGB332_HTML_DarkGray
#define ZXN_RGB332_HTML_DarkGrey  __ZXN_RGB332_HTML_DarkGrey
#define ZXN_RGB332_HTML_DarkGreen  __ZXN_RGB332_HTML_DarkGreen
#define ZXN_RGB332_HTML_DarkKhaki  __ZXN_RGB332_HTML_DarkKhaki
#define ZXN_RGB332_HTML_DarkMagenta  __ZXN_RGB332_HTML_DarkMagenta
#define ZXN_RGB332_HTML_DarkOliveGreen  __ZXN_RGB332_HTML_DarkOliveGreen
#define ZXN_RGB332_HTML_DarkOrange  __ZXN_RGB332_HTML_DarkOrange
#define ZXN_RGB332_HTML_DarkOrchid  __ZXN_RGB332_HTML_DarkOrchid
#define ZXN_RGB332_HTML_DarkRed  __ZXN_RGB332_HTML_DarkRed
#define ZXN_RGB332_HTML_DarkSalmon  __ZXN_RGB332_HTML_DarkSalmon
#define ZXN_RGB332_HTML_DarkSeaGreen  __ZXN_RGB332_HTML_DarkSeaGreen
#define ZXN_RGB332_HTML_DarkSlateBlue  __ZXN_RGB332_HTML_DarkSlateBlue
#define ZXN_RGB332_HTML_DarkSlateGray  __ZXN_RGB332_HTML_DarkSlateGray
#define ZXN_RGB332_HTML_DarkSlateGrey  __ZXN_RGB332_HTML_DarkSlateGrey
#define ZXN_RGB332_HTML_DarkTurquoise  __ZXN_RGB332_HTML_DarkTurquoise
#define ZXN_RGB332_HTML_DarkViolet  __ZXN_RGB332_HTML_DarkViolet
#define ZXN_RGB332_HTML_DeepPink  __ZXN_RGB332_HTML_DeepPink
#define ZXN_RGB332_HTML_DeepSkyBlue  __ZXN_RGB332_HTML_DeepSkyBlue
#define ZXN_RGB332_HTML_DimGray  __ZXN_RGB332_HTML_DimGray
#define ZXN_RGB332_HTML_DimGrey  __ZXN_RGB332_HTML_DimGrey
#define ZXN_RGB332_HTML_DodgerBlue  __ZXN_RGB332_HTML_DodgerBlue
#define ZXN_RGB332_HTML_FireBrick  __ZXN_RGB332_HTML_FireBrick
#define ZXN_RGB332_HTML_FloralWhite  __ZXN_RGB332_HTML_FloralWhite
#define ZXN_RGB332_HTML_ForestGreen  __ZXN_RGB332_HTML_ForestGreen
#define ZXN_RGB332_HTML_Fuchsia  __ZXN_RGB332_HTML_Fuchsia
#define ZXN_RGB332_HTML_Gainsboro  __ZXN_RGB332_HTML_Gainsboro
#define ZXN_RGB332_HTML_GhostWhite  __ZXN_RGB332_HTML_GhostWhite
#define ZXN_RGB332_HTML_Gold  __ZXN_RGB332_HTML_Gold
#define ZXN_RGB332_HTML_GoldenRod  __ZXN_RGB332_HTML_GoldenRod
#define ZXN_RGB332_HTML_Gray  __ZXN_RGB332_HTML_Gray
#define ZXN_RGB332_HTML_Grey  __ZXN_RGB332_HTML_Grey
#define ZXN_RGB332_HTML_Green  __ZXN_RGB332_HTML_Green
#define ZXN_RGB332_HTML_GreenYellow  __ZXN_RGB332_HTML_GreenYellow
#define ZXN_RGB332_HTML_HoneyDew  __ZXN_RGB332_HTML_HoneyDew
#define ZXN_RGB332_HTML_HotPink  __ZXN_RGB332_HTML_HotPink
#define ZXN_RGB332_HTML_IndianRed  __ZXN_RGB332_HTML_IndianRed
#define ZXN_RGB332_HTML_Indigo  __ZXN_RGB332_HTML_Indigo
#define ZXN_RGB332_HTML_Ivory  __ZXN_RGB332_HTML_Ivory
#define ZXN_RGB332_HTML_Khaki  __ZXN_RGB332_HTML_Khaki
#define ZXN_RGB332_HTML_Lavender  __ZXN_RGB332_HTML_Lavender
#define ZXN_RGB332_HTML_LavenderBlush  __ZXN_RGB332_HTML_LavenderBlush
#define ZXN_RGB332_HTML_LawnGreen  __ZXN_RGB332_HTML_LawnGreen
#define ZXN_RGB332_HTML_LemonChiffon  __ZXN_RGB332_HTML_LemonChiffon
#define ZXN_RGB332_HTML_LightBlue  __ZXN_RGB332_HTML_LightBlue
#define ZXN_RGB332_HTML_LightCoral  __ZXN_RGB332_HTML_LightCoral
#define ZXN_RGB332_HTML_LightCyan  __ZXN_RGB332_HTML_LightCyan
#define ZXN_RGB332_HTML_LightGoldenRodYellow  __ZXN_RGB332_HTML_LightGoldenRodYellow
#define ZXN_RGB332_HTML_LightGray  __ZXN_RGB332_HTML_LightGray
#define ZXN_RGB332_HTML_LightGrey  __ZXN_RGB332_HTML_LightGrey
#define ZXN_RGB332_HTML_LightGreen  __ZXN_RGB332_HTML_LightGreen
#define ZXN_RGB332_HTML_LightPink  __ZXN_RGB332_HTML_LightPink
#define ZXN_RGB332_HTML_LightSalmon  __ZXN_RGB332_HTML_LightSalmon
#define ZXN_RGB332_HTML_LightSeaGreen  __ZXN_RGB332_HTML_LightSeaGreen
#define ZXN_RGB332_HTML_LightSkyBlue  __ZXN_RGB332_HTML_LightSkyBlue
#define ZXN_RGB332_HTML_LightSlateGray  __ZXN_RGB332_HTML_LightSlateGray
#define ZXN_RGB332_HTML_LightSlateGrey  __ZXN_RGB332_HTML_LightSlateGrey
#define ZXN_RGB332_HTML_LightSteelBlue  __ZXN_RGB332_HTML_LightSteelBlue
#define ZXN_RGB332_HTML_LightYellow  __ZXN_RGB332_HTML_LightYellow
#define ZXN_RGB332_HTML_Lime  __ZXN_RGB332_HTML_Lime
#define ZXN_RGB332_HTML_LimeGreen  __ZXN_RGB332_HTML_LimeGreen
#define ZXN_RGB332_HTML_Linen  __ZXN_RGB332_HTML_Linen
#define ZXN_RGB332_HTML_Magenta  __ZXN_RGB332_HTML_Magenta
#define ZXN_RGB332_HTML_Maroon  __ZXN_RGB332_HTML_Maroon
#define ZXN_RGB332_HTML_MediumAquaMarine  __ZXN_RGB332_HTML_MediumAquaMarine
#define ZXN_RGB332_HTML_MediumBlue  __ZXN_RGB332_HTML_MediumBlue
#define ZXN_RGB332_HTML_MediumOrchid  __ZXN_RGB332_HTML_MediumOrchid
#define ZXN_RGB332_HTML_MediumPurple  __ZXN_RGB332_HTML_MediumPurple
#define ZXN_RGB332_HTML_MediumSeaGreen  __ZXN_RGB332_HTML_MediumSeaGreen
#define ZXN_RGB332_HTML_MediumSlateBlue  __ZXN_RGB332_HTML_MediumSlateBlue
#define ZXN_RGB332_HTML_MediumSpringGreen  __ZXN_RGB332_HTML_MediumSpringGreen
#define ZXN_RGB332_HTML_MediumTurquoise  __ZXN_RGB332_HTML_MediumTurquoise
#define ZXN_RGB332_HTML_MediumVioletRed  __ZXN_RGB332_HTML_MediumVioletRed
#define ZXN_RGB332_HTML_MidnightBlue  __ZXN_RGB332_HTML_MidnightBlue
#define ZXN_RGB332_HTML_MintCream  __ZXN_RGB332_HTML_MintCream
#define ZXN_RGB332_HTML_MistyRose  __ZXN_RGB332_HTML_MistyRose
#define ZXN_RGB332_HTML_Moccasin  __ZXN_RGB332_HTML_Moccasin
#define ZXN_RGB332_HTML_NavajoWhite  __ZXN_RGB332_HTML_NavajoWhite
#define ZXN_RGB332_HTML_Navy  __ZXN_RGB332_HTML_Navy
#define ZXN_RGB332_HTML_OldLace  __ZXN_RGB332_HTML_OldLace
#define ZXN_RGB332_HTML_Olive  __ZXN_RGB332_HTML_Olive
#define ZXN_RGB332_HTML_OliveDrab  __ZXN_RGB332_HTML_OliveDrab
#define ZXN_RGB332_HTML_Orange  __ZXN_RGB332_HTML_Orange
#define ZXN_RGB332_HTML_OrangeRed  __ZXN_RGB332_HTML_OrangeRed
#define ZXN_RGB332_HTML_Orchid  __ZXN_RGB332_HTML_Orchid
#define ZXN_RGB332_HTML_PaleGoldenRod  __ZXN_RGB332_HTML_PaleGoldenRod
#define ZXN_RGB332_HTML_PaleGreen  __ZXN_RGB332_HTML_PaleGreen
#define ZXN_RGB332_HTML_PaleTurquoise  __ZXN_RGB332_HTML_PaleTurquoise
#define ZXN_RGB332_HTML_PaleVioletRed  __ZXN_RGB332_HTML_PaleVioletRed
#define ZXN_RGB332_HTML_PapayaWhip  __ZXN_RGB332_HTML_PapayaWhip
#define ZXN_RGB332_HTML_PeachPuff  __ZXN_RGB332_HTML_PeachPuff
#define ZXN_RGB332_HTML_Peru  __ZXN_RGB332_HTML_Peru
#define ZXN_RGB332_HTML_Pink  __ZXN_RGB332_HTML_Pink
#define ZXN_RGB332_HTML_Plum  __ZXN_RGB332_HTML_Plum
#define ZXN_RGB332_HTML_PowderBlue  __ZXN_RGB332_HTML_PowderBlue
#define ZXN_RGB332_HTML_Purple  __ZXN_RGB332_HTML_Purple
#define ZXN_RGB332_HTML_RebeccaPurple  __ZXN_RGB332_HTML_RebeccaPurple
#define ZXN_RGB332_HTML_Red  __ZXN_RGB332_HTML_Red
#define ZXN_RGB332_HTML_RosyBrown  __ZXN_RGB332_HTML_RosyBrown
#define ZXN_RGB332_HTML_RoyalBlue  __ZXN_RGB332_HTML_RoyalBlue
#define ZXN_RGB332_HTML_SaddleBrown  __ZXN_RGB332_HTML_SaddleBrown
#define ZXN_RGB332_HTML_Salmon  __ZXN_RGB332_HTML_Salmon
#define ZXN_RGB332_HTML_SandyBrown  __ZXN_RGB332_HTML_SandyBrown
#define ZXN_RGB332_HTML_SeaGreen  __ZXN_RGB332_HTML_SeaGreen
#define ZXN_RGB332_HTML_SeaShell  __ZXN_RGB332_HTML_SeaShell
#define ZXN_RGB332_HTML_Sienna  __ZXN_RGB332_HTML_Sienna
#define ZXN_RGB332_HTML_Silver  __ZXN_RGB332_HTML_Silver
#define ZXN_RGB332_HTML_SkyBlue  __ZXN_RGB332_HTML_SkyBlue
#define ZXN_RGB332_HTML_SlateBlue  __ZXN_RGB332_HTML_SlateBlue
#define ZXN_RGB332_HTML_SlateGray  __ZXN_RGB332_HTML_SlateGray
#define ZXN_RGB332_HTML_SlateGrey  __ZXN_RGB332_HTML_SlateGrey
#define ZXN_RGB332_HTML_Snow  __ZXN_RGB332_HTML_Snow
#define ZXN_RGB332_HTML_SpringGreen  __ZXN_RGB332_HTML_SpringGreen
#define ZXN_RGB332_HTML_SteelBlue  __ZXN_RGB332_HTML_SteelBlue
#define ZXN_RGB332_HTML_Tan  __ZXN_RGB332_HTML_Tan
#define ZXN_RGB332_HTML_Teal  __ZXN_RGB332_HTML_Teal
#define ZXN_RGB332_HTML_Thistle  __ZXN_RGB332_HTML_Thistle
#define ZXN_RGB332_HTML_Tomato  __ZXN_RGB332_HTML_Tomato
#define ZXN_RGB332_HTML_Turquoise  __ZXN_RGB332_HTML_Turquoise
#define ZXN_RGB332_HTML_Violet  __ZXN_RGB332_HTML_Violet
#define ZXN_RGB332_HTML_Wheat  __ZXN_RGB332_HTML_Wheat
#define ZXN_RGB332_HTML_White  __ZXN_RGB332_HTML_White
#define ZXN_RGB332_HTML_WhiteSmoke  __ZXN_RGB332_HTML_WhiteSmoke
#define ZXN_RGB332_HTML_Yellow  __ZXN_RGB332_HTML_Yellow
#define ZXN_RGB332_HTML_YellowGreen  __ZXN_RGB332_HTML_YellowGreen

#define ZXN_RGB333_HTML_AliceBlue  __ZXN_RGB333_HTML_AliceBlue
#define ZXN_RGB333_HTML_AntiqueWhite  __ZXN_RGB333_HTML_AntiqueWhite
#define ZXN_RGB333_HTML_Aqua  __ZXN_RGB333_HTML_Aqua
#define ZXN_RGB333_HTML_Aquamarine  __ZXN_RGB333_HTML_Aquamarine
#define ZXN_RGB333_HTML_Azure  __ZXN_RGB333_HTML_Azure
#define ZXN_RGB333_HTML_Beige  __ZXN_RGB333_HTML_Beige
#define ZXN_RGB333_HTML_Bisque  __ZXN_RGB333_HTML_Bisque
#define ZXN_RGB333_HTML_Black  __ZXN_RGB333_HTML_Black
#define ZXN_RGB333_HTML_BlanchedAlmond  __ZXN_RGB333_HTML_BlanchedAlmond
#define ZXN_RGB333_HTML_Blue  __ZXN_RGB333_HTML_Blue
#define ZXN_RGB333_HTML_BlueViolet  __ZXN_RGB333_HTML_BlueViolet
#define ZXN_RGB333_HTML_Brown  __ZXN_RGB333_HTML_Brown
#define ZXN_RGB333_HTML_BurlyWood  __ZXN_RGB333_HTML_BurlyWood
#define ZXN_RGB333_HTML_CadetBlue  __ZXN_RGB333_HTML_CadetBlue
#define ZXN_RGB333_HTML_Chartreuse  __ZXN_RGB333_HTML_Chartreuse
#define ZXN_RGB333_HTML_Chocolate  __ZXN_RGB333_HTML_Chocolate
#define ZXN_RGB333_HTML_Coral  __ZXN_RGB333_HTML_Coral
#define ZXN_RGB333_HTML_CornflowerBlue  __ZXN_RGB333_HTML_CornflowerBlue
#define ZXN_RGB333_HTML_Cornsilk  __ZXN_RGB333_HTML_Cornsilk
#define ZXN_RGB333_HTML_Crimson  __ZXN_RGB333_HTML_Crimson
#define ZXN_RGB333_HTML_Cyan  __ZXN_RGB333_HTML_Cyan
#define ZXN_RGB333_HTML_DarkBlue  __ZXN_RGB333_HTML_DarkBlue
#define ZXN_RGB333_HTML_DarkCyan  __ZXN_RGB333_HTML_DarkCyan
#define ZXN_RGB333_HTML_DarkGoldenRod  __ZXN_RGB333_HTML_DarkGoldenRod
#define ZXN_RGB333_HTML_DarkGray  __ZXN_RGB333_HTML_DarkGray
#define ZXN_RGB333_HTML_DarkGrey  __ZXN_RGB333_HTML_DarkGrey
#define ZXN_RGB333_HTML_DarkGreen  __ZXN_RGB333_HTML_DarkGreen
#define ZXN_RGB333_HTML_DarkKhaki  __ZXN_RGB333_HTML_DarkKhaki
#define ZXN_RGB333_HTML_DarkMagenta  __ZXN_RGB333_HTML_DarkMagenta
#define ZXN_RGB333_HTML_DarkOliveGreen  __ZXN_RGB333_HTML_DarkOliveGreen
#define ZXN_RGB333_HTML_DarkOrange  __ZXN_RGB333_HTML_DarkOrange
#define ZXN_RGB333_HTML_DarkOrchid  __ZXN_RGB333_HTML_DarkOrchid
#define ZXN_RGB333_HTML_DarkRed  __ZXN_RGB333_HTML_DarkRed
#define ZXN_RGB333_HTML_DarkSalmon  __ZXN_RGB333_HTML_DarkSalmon
#define ZXN_RGB333_HTML_DarkSeaGreen  __ZXN_RGB333_HTML_DarkSeaGreen
#define ZXN_RGB333_HTML_DarkSlateBlue  __ZXN_RGB333_HTML_DarkSlateBlue
#define ZXN_RGB333_HTML_DarkSlateGray  __ZXN_RGB333_HTML_DarkSlateGray
#define ZXN_RGB333_HTML_DarkSlateGrey  __ZXN_RGB333_HTML_DarkSlateGrey
#define ZXN_RGB333_HTML_DarkTurquoise  __ZXN_RGB333_HTML_DarkTurquoise
#define ZXN_RGB333_HTML_DarkViolet  __ZXN_RGB333_HTML_DarkViolet
#define ZXN_RGB333_HTML_DeepPink  __ZXN_RGB333_HTML_DeepPink
#define ZXN_RGB333_HTML_DeepSkyBlue  __ZXN_RGB333_HTML_DeepSkyBlue
#define ZXN_RGB333_HTML_DimGray  __ZXN_RGB333_HTML_DimGray
#define ZXN_RGB333_HTML_DimGrey  __ZXN_RGB333_HTML_DimGrey
#define ZXN_RGB333_HTML_DodgerBlue  __ZXN_RGB333_HTML_DodgerBlue
#define ZXN_RGB333_HTML_FireBrick  __ZXN_RGB333_HTML_FireBrick
#define ZXN_RGB333_HTML_FloralWhite  __ZXN_RGB333_HTML_FloralWhite
#define ZXN_RGB333_HTML_ForestGreen  __ZXN_RGB333_HTML_ForestGreen
#define ZXN_RGB333_HTML_Fuchsia  __ZXN_RGB333_HTML_Fuchsia
#define ZXN_RGB333_HTML_Gainsboro  __ZXN_RGB333_HTML_Gainsboro
#define ZXN_RGB333_HTML_GhostWhite  __ZXN_RGB333_HTML_GhostWhite
#define ZXN_RGB333_HTML_Gold  __ZXN_RGB333_HTML_Gold
#define ZXN_RGB333_HTML_GoldenRod  __ZXN_RGB333_HTML_GoldenRod
#define ZXN_RGB333_HTML_Gray  __ZXN_RGB333_HTML_Gray
#define ZXN_RGB333_HTML_Grey  __ZXN_RGB333_HTML_Grey
#define ZXN_RGB333_HTML_Green  __ZXN_RGB333_HTML_Green
#define ZXN_RGB333_HTML_GreenYellow  __ZXN_RGB333_HTML_GreenYellow
#define ZXN_RGB333_HTML_HoneyDew  __ZXN_RGB333_HTML_HoneyDew
#define ZXN_RGB333_HTML_HotPink  __ZXN_RGB333_HTML_HotPink
#define ZXN_RGB333_HTML_IndianRed  __ZXN_RGB333_HTML_IndianRed
#define ZXN_RGB333_HTML_Indigo  __ZXN_RGB333_HTML_Indigo
#define ZXN_RGB333_HTML_Ivory  __ZXN_RGB333_HTML_Ivory
#define ZXN_RGB333_HTML_Khaki  __ZXN_RGB333_HTML_Khaki
#define ZXN_RGB333_HTML_Lavender  __ZXN_RGB333_HTML_Lavender
#define ZXN_RGB333_HTML_LavenderBlush  __ZXN_RGB333_HTML_LavenderBlush
#define ZXN_RGB333_HTML_LawnGreen  __ZXN_RGB333_HTML_LawnGreen
#define ZXN_RGB333_HTML_LemonChiffon  __ZXN_RGB333_HTML_LemonChiffon
#define ZXN_RGB333_HTML_LightBlue  __ZXN_RGB333_HTML_LightBlue
#define ZXN_RGB333_HTML_LightCoral  __ZXN_RGB333_HTML_LightCoral
#define ZXN_RGB333_HTML_LightCyan  __ZXN_RGB333_HTML_LightCyan
#define ZXN_RGB333_HTML_LightGoldenRodYellow  __ZXN_RGB333_HTML_LightGoldenRodYellow
#define ZXN_RGB333_HTML_LightGray  __ZXN_RGB333_HTML_LightGray
#define ZXN_RGB333_HTML_LightGrey  __ZXN_RGB333_HTML_LightGrey
#define ZXN_RGB333_HTML_LightGreen  __ZXN_RGB333_HTML_LightGreen
#define ZXN_RGB333_HTML_LightPink  __ZXN_RGB333_HTML_LightPink
#define ZXN_RGB333_HTML_LightSalmon  __ZXN_RGB333_HTML_LightSalmon
#define ZXN_RGB333_HTML_LightSeaGreen  __ZXN_RGB333_HTML_LightSeaGreen
#define ZXN_RGB333_HTML_LightSkyBlue  __ZXN_RGB333_HTML_LightSkyBlue
#define ZXN_RGB333_HTML_LightSlateGray  __ZXN_RGB333_HTML_LightSlateGray
#define ZXN_RGB333_HTML_LightSlateGrey  __ZXN_RGB333_HTML_LightSlateGrey
#define ZXN_RGB333_HTML_LightSteelBlue  __ZXN_RGB333_HTML_LightSteelBlue
#define ZXN_RGB333_HTML_LightYellow  __ZXN_RGB333_HTML_LightYellow
#define ZXN_RGB333_HTML_Lime  __ZXN_RGB333_HTML_Lime
#define ZXN_RGB333_HTML_LimeGreen  __ZXN_RGB333_HTML_LimeGreen
#define ZXN_RGB333_HTML_Linen  __ZXN_RGB333_HTML_Linen
#define ZXN_RGB333_HTML_Magenta  __ZXN_RGB333_HTML_Magenta
#define ZXN_RGB333_HTML_Maroon  __ZXN_RGB333_HTML_Maroon
#define ZXN_RGB333_HTML_MediumAquaMarine  __ZXN_RGB333_HTML_MediumAquaMarine
#define ZXN_RGB333_HTML_MediumBlue  __ZXN_RGB333_HTML_MediumBlue
#define ZXN_RGB333_HTML_MediumOrchid  __ZXN_RGB333_HTML_MediumOrchid
#define ZXN_RGB333_HTML_MediumPurple  __ZXN_RGB333_HTML_MediumPurple
#define ZXN_RGB333_HTML_MediumSeaGreen  __ZXN_RGB333_HTML_MediumSeaGreen
#define ZXN_RGB333_HTML_MediumSlateBlue  __ZXN_RGB333_HTML_MediumSlateBlue
#define ZXN_RGB333_HTML_MediumSpringGreen  __ZXN_RGB333_HTML_MediumSpringGreen
#define ZXN_RGB333_HTML_MediumTurquoise  __ZXN_RGB333_HTML_MediumTurquoise
#define ZXN_RGB333_HTML_MediumVioletRed  __ZXN_RGB333_HTML_MediumVioletRed
#define ZXN_RGB333_HTML_MidnightBlue  __ZXN_RGB333_HTML_MidnightBlue
#define ZXN_RGB333_HTML_MintCream  __ZXN_RGB333_HTML_MintCream
#define ZXN_RGB333_HTML_MistyRose  __ZXN_RGB333_HTML_MistyRose
#define ZXN_RGB333_HTML_Moccasin  __ZXN_RGB333_HTML_Moccasin
#define ZXN_RGB333_HTML_NavajoWhite  __ZXN_RGB333_HTML_NavajoWhite
#define ZXN_RGB333_HTML_Navy  __ZXN_RGB333_HTML_Navy
#define ZXN_RGB333_HTML_OldLace  __ZXN_RGB333_HTML_OldLace
#define ZXN_RGB333_HTML_Olive  __ZXN_RGB333_HTML_Olive
#define ZXN_RGB333_HTML_OliveDrab  __ZXN_RGB333_HTML_OliveDrab
#define ZXN_RGB333_HTML_Orange  __ZXN_RGB333_HTML_Orange
#define ZXN_RGB333_HTML_OrangeRed  __ZXN_RGB333_HTML_OrangeRed
#define ZXN_RGB333_HTML_Orchid  __ZXN_RGB333_HTML_Orchid
#define ZXN_RGB333_HTML_PaleGoldenRod  __ZXN_RGB333_HTML_PaleGoldenRod
#define ZXN_RGB333_HTML_PaleGreen  __ZXN_RGB333_HTML_PaleGreen
#define ZXN_RGB333_HTML_PaleTurquoise  __ZXN_RGB333_HTML_PaleTurquoise
#define ZXN_RGB333_HTML_PaleVioletRed  __ZXN_RGB333_HTML_PaleVioletRed
#define ZXN_RGB333_HTML_PapayaWhip  __ZXN_RGB333_HTML_PapayaWhip
#define ZXN_RGB333_HTML_PeachPuff  __ZXN_RGB333_HTML_PeachPuff
#define ZXN_RGB333_HTML_Peru  __ZXN_RGB333_HTML_Peru
#define ZXN_RGB333_HTML_Pink  __ZXN_RGB333_HTML_Pink
#define ZXN_RGB333_HTML_Plum  __ZXN_RGB333_HTML_Plum
#define ZXN_RGB333_HTML_PowderBlue  __ZXN_RGB333_HTML_PowderBlue
#define ZXN_RGB333_HTML_Purple  __ZXN_RGB333_HTML_Purple
#define ZXN_RGB333_HTML_RebeccaPurple  __ZXN_RGB333_HTML_RebeccaPurple
#define ZXN_RGB333_HTML_Red  __ZXN_RGB333_HTML_Red
#define ZXN_RGB333_HTML_RosyBrown  __ZXN_RGB333_HTML_RosyBrown
#define ZXN_RGB333_HTML_RoyalBlue  __ZXN_RGB333_HTML_RoyalBlue
#define ZXN_RGB333_HTML_SaddleBrown  __ZXN_RGB333_HTML_SaddleBrown
#define ZXN_RGB333_HTML_Salmon  __ZXN_RGB333_HTML_Salmon
#define ZXN_RGB333_HTML_SandyBrown  __ZXN_RGB333_HTML_SandyBrown
#define ZXN_RGB333_HTML_SeaGreen  __ZXN_RGB333_HTML_SeaGreen
#define ZXN_RGB333_HTML_SeaShell  __ZXN_RGB333_HTML_SeaShell
#define ZXN_RGB333_HTML_Sienna  __ZXN_RGB333_HTML_Sienna
#define ZXN_RGB333_HTML_Silver  __ZXN_RGB333_HTML_Silver
#define ZXN_RGB333_HTML_SkyBlue  __ZXN_RGB333_HTML_SkyBlue
#define ZXN_RGB333_HTML_SlateBlue  __ZXN_RGB333_HTML_SlateBlue
#define ZXN_RGB333_HTML_SlateGray  __ZXN_RGB333_HTML_SlateGray
#define ZXN_RGB333_HTML_SlateGrey  __ZXN_RGB333_HTML_SlateGrey
#define ZXN_RGB333_HTML_Snow  __ZXN_RGB333_HTML_Snow
#define ZXN_RGB333_HTML_SpringGreen  __ZXN_RGB333_HTML_SpringGreen
#define ZXN_RGB333_HTML_SteelBlue  __ZXN_RGB333_HTML_SteelBlue
#define ZXN_RGB333_HTML_Tan  __ZXN_RGB333_HTML_Tan
#define ZXN_RGB333_HTML_Teal  __ZXN_RGB333_HTML_Teal
#define ZXN_RGB333_HTML_Thistle  __ZXN_RGB333_HTML_Thistle
#define ZXN_RGB333_HTML_Tomato  __ZXN_RGB333_HTML_Tomato
#define ZXN_RGB333_HTML_Turquoise  __ZXN_RGB333_HTML_Turquoise
#define ZXN_RGB333_HTML_Violet  __ZXN_RGB333_HTML_Violet
#define ZXN_RGB333_HTML_Wheat  __ZXN_RGB333_HTML_Wheat
#define ZXN_RGB333_HTML_White  __ZXN_RGB333_HTML_White
#define ZXN_RGB333_HTML_WhiteSmoke  __ZXN_RGB333_HTML_WhiteSmoke
#define ZXN_RGB333_HTML_Yellow  __ZXN_RGB333_HTML_Yellow
#define ZXN_RGB333_HTML_YellowGreen  __ZXN_RGB333_HTML_YellowGreen

#endif
